/* FINAL DRAGON STATUS DISPLAY SCREEN INITIALIZER 4/25/05
JESSE HARRIS
INITIALIZES STATUS SCREEN FOR DISPLAY
*/
#include <mygba.h>
#include <hel.h>
#include <iostream.h>
#include "stuff.hpp"
#include "drawtextbox.h"

extern u16 delay;
extern u8 sprites[127];
extern player watashi;
extern map maplist[];
extern u16 exptable[];
extern TCustomTextInfo g_TextInfo;


void myStatusInit()
{
        char tempy[26];
        delay = 20;  //global delay

        //visual functions
        //turn off sprites
        for(int x = 0; x < 119; x++)
        {
            ham_SetObjVisible(sprites[x], 0);
        }
        //enable text background
        ham_SetBgVisible(2,1);
        //draw main border
        drawTextBox(g_TextInfo,0,0,29,19);

        //test code
        //kept for use in testing future upgrades
        /*
        sprintf(tempy, "STATE: %d", watashi.playerstate);
        hel_CustomTextPrint(&g_TextInfo, 2, 7, tempy);  // For testing
        sprintf(tempy, "X: %d", watashi.x);
        hel_CustomTextPrint(&g_TextInfo, 2, 5, tempy);  // For testing
        sprintf(tempy, "Y: %d", watashi.y);
        hel_CustomTextPrint(&g_TextInfo, 2, 6, tempy);  // For testing
        */
        //end test code
        
        //draw border for HP/MP/Level and display contents
        drawTextBox(g_TextInfo,1,1,15,4);
        sprintf(tempy, "HP: %d/%d  ", watashi.hp, watashi.maxhp);
        hel_CustomTextPrint(&g_TextInfo, 2, 2, tempy);
        sprintf(tempy, "MP: %d/%d  ", watashi.mp, watashi.maxmp);
        hel_CustomTextPrint(&g_TextInfo, 2, 3, tempy);
        sprintf(tempy, "Level: %d  ", watashi.level);
        hel_CustomTextPrint(&g_TextInfo, 2, 4, tempy);
        
        u8 number = 0;
        //PLOT related statistics
        if(watashi.playerstate & PS_CRYSTAL1)
        {
            number++;
        }
        if(watashi.playerstate & PS_CRYSTAL2)
        {
            number++;
        }
        if(watashi.playerstate & PS_CRYSTAL3)
        {
            number++;
        }
        if(watashi.playerstate & PS_CRYSTAL4)
        {
            number++;
        }
        if(watashi.playerstate & PS_CRYSTAL5)
        {
            number++;
        }
        drawTextBox(g_TextInfo,1,6,15,2);
        sprintf(tempy, "Crystals: %d  ", number);
        hel_CustomTextPrint(&g_TextInfo, 2, 7, tempy);
        //end PLOT related statistics
        
        //PLOT equipped items
        drawTextBox(g_TextInfo,1,9,15,5);
        hel_CustomTextPrint(&g_TextInfo, 2, 10, "Owned:");
        if(watashi.playerstate & PS_SWAMPBOOTS)
        {
            hel_CustomTextPrint(&g_TextInfo, 2, 11, "  Swamp boots");
        }
        if(watashi.playerstate & PS_HIKINGBOOTS)
        {
        hel_CustomTextPrint(&g_TextInfo, 2, 12, "  Hiking Boots");
        }
        if(watashi.playerstate & PS_DESERTSHOES)
        {
        hel_CustomTextPrint(&g_TextInfo, 2, 13, "  Desert Shoes");
        }
        //end PLOT equipped items
        
        
        //draw box and contents for experience and level
        drawTextBox(g_TextInfo,1,15,27,3);
        sprintf(tempy, "Exp: %d", watashi.exp);
        hel_CustomTextPrint(&g_TextInfo, 2, 16, tempy);
        sprintf(tempy, "Next level at : %d", exptable[watashi.level + 1]);
        hel_CustomTextPrint(&g_TextInfo, 2, 17, tempy);
    
    return; // when finished exit
}


/* END OF FILE */
